% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program GeometricTransformations.m
[M,  map] = imread('Church.jpg',  'jpeg');
M1 = rgb2gray(M);

M2 = imresize(M1,  0.25,  'bicubic'); 
        % scale the image by 0.25 using cubic interpolation.
showImage(M2,  'grayscale');

M3 = imrotate(M2,  45,  'bicubic');  
        % rotate M2 counter-clock wise by 45 degrees.
showImage(M3,   'grayscale');

M4 = imcrop(M3,  [185 335 340 327]);
showImage(M4,   'grayscale');
